/* $Id: speed.c,v 1.2 1998/07/20 23:37:11 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Keith Bayern */

#include <stdio.h>
#include <stdlib.h>

#include "hpe1432.h"

#define BLOCK_SIZE 4096
#define NUM_BLOCKS 1024

void main()
{
ViSession	session;
ViInt32		channels[10];
ViInt32		gid;
ViReal64	data[BLOCK_SIZE];
char		st[100];
ViInt32		actualCount;
ViInt32		i;
ViInt32		baflag;
ViStatus	vierr;

    /* initialize instrument  This code ASSUMES hpe1432 at address 8 */
    vierr=hpe1432_init("VXI0::8::INSTR",0,1,&session);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("1 error %d = %s\n",vierr,st);	    
        exit(0);
    }

    /* make an array of input channel numbers (only one in this simple demo) */
    channels[0]=1;

    vierr=hpe1432_createChannelGroup(session,1,channels,&gid);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("2 error %d = %s\n",vierr,st);
        exit(0);
    }

    /* set the fifo blocksize */
    vierr=hpe1432_setBlocksize(session,gid,BLOCK_SIZE);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("3 error %d = %s\n",vierr,st);
        exit(0);
    }

    /* get some data coming */
    vierr=hpe1432_initMeasure(session,gid);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("4 error %d = %s\n",vierr,st);
        exit(0);
    }

    printf("START reading %ld bytes\n",(long)BLOCK_SIZE*NUM_BLOCKS);

    for(i=0;i<NUM_BLOCKS;i++)
    {

    do {
        /* get some data coming */
        vierr=hpe1432_blockAvailable(session,gid,&baflag);
        if(vierr)
        {
            hpe1432_error_message(session,vierr,st);
            printf("5 error %d = %s\n",vierr,st);
            exit(0);
        }
    } while (baflag==0);

    if(baflag<0)
    {
	printf("FIFO overflow, exiting \n");
	exit(0);
    }

    /* wait for the data and then read it */
    vierr=hpe1432_readFloat64Data(session,gid,
                                  HPE1432_TIME_DATA,
                                  data,
                                  BLOCK_SIZE,
                                  &actualCount,
                                  HPE1432_NO_WAIT_FLAG);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("6 error %d = %s\n",vierr,st);
        exit(0);
    }

    }

    printf("DONE reading %ld bytes\n",(long)BLOCK_SIZE*NUM_BLOCKS);

    
}





